<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Tcamion
 *
 * @ORM\Table(name="tcamion", indexes={@ORM\Index(name="idpertenencia", columns={"idpertenencia"})})
 * @ORM\Entity
 */
class Tcamion
{
    /**
     * @var int
     *
     * @ORM\Column(name="idcamion", type="smallint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $idcamion;

    /**
     * @var string
     *
     * @ORM\Column(name="placa", type="string", length=12, nullable=false)
     */
    private $placa;

    /**
     * @var string
     *
     * @ORM\Column(name="chasis", type="string", length=20, nullable=false)
     */
    private $chasis;

    /**
     * @var string|null
     *
     * @ORM\Column(name="marca", type="string", length=50, nullable=true, options={"default"="NULL"})
     */
    private $marca = '';

    /**
     * @var int|null
     *
     * @ORM\Column(name="modelo", type="integer", nullable=true, options={"default"="NULL"})
     */
    private $modelo = NULL;

    /**
     * @var string|null
     *
     * @ORM\Column(name="foto", type="string", length=50, nullable=true, options={"default"="NULL"})
     */
    private $foto = '';

    /**
     * @var bool|null
     *
     * @ORM\Column(name="estado", type="boolean", nullable=true, options={"default"="NULL"})
     */
    private $estado = '';

    /**
     * @var \Tpertenencia
     *
     * @ORM\ManyToOne(targetEntity="Tpertenencia")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="idpertenencia", referencedColumnName="idpertenencia")
     * })
     */
    private $idpertenencia;

    public function getIdcamion(): ?int
    {
        return $this->idcamion;
    }

    public function getPlaca(): ?string
    {
        return $this->placa;
    }

    public function setPlaca(string $placa): self
    {
        $this->placa = $placa;

        return $this;
    }

    public function getChasis(): ?string
    {
        return $this->chasis;
    }

    public function setChasis(string $chasis): self
    {
        $this->chasis = $chasis;

        return $this;
    }

    public function getMarca(): ?string
    {
        return $this->marca;
    }

    public function setMarca(?string $marca): self
    {
        $this->marca = $marca;

        return $this;
    }

    public function getModelo(): ?int
    {
        return $this->modelo;
    }

    public function setModelo(?int $modelo): self
    {
        $this->modelo = $modelo;

        return $this;
    }

    public function getFoto(): ?string
    {
        return $this->foto;
    }

    public function setFoto(?string $foto): self
    {
        $this->foto = $foto;

        return $this;
    }

    public function getEstado(): ?bool
    {
        return $this->estado;
    }

    public function setEstado(?bool $estado): self
    {
        $this->estado = $estado;

        return $this;
    }

    public function getIdpertenencia(): ?Tpertenencia
    {
        return $this->idpertenencia;
    }

    public function setIdpertenencia(?Tpertenencia $idpertenencia): self
    {
        $this->idpertenencia = $idpertenencia;

        return $this;
    }

    public function __toString()
    {
        return $this->getPlaca();
    }

}
