<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;

// obligatorio colocar es para la validación de los formularios por anotacioón
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Tfactinternal
 *
 * @ORM\Table(name="tfactinternal", indexes={@ORM\Index(name="idpago", columns={"idpago"}), @ORM\Index(name="idusuario", columns={"idusuario"}), @ORM\Index(name="idinternacional", columns={"idinternacional"}) })
 * @ORM\Entity
 */
class Tfactinternal
{
    /**
     * @var int
     *
     * @ORM\Column(name="idfactinternal", type="smallint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $idfactinternal;

    /**
     * @var string
     * @ORM\Column(name="monto", type="string", length=50, nullable=false, options={"default"="0"})
     * @Assert\NotBlank(
     *      message = "No puede estar en blanco",
     *)
     * @Assert\Type(
     *     type="numeric",
     *     message="Valor numérico entero o fracción Ejm. 95.00"
     * )
     */
    private $monto;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="fpagofact", type="datetime", nullable=true, options={"default"="CURRENT_TIMESTAMP"})
     */
    private $fpagofact;


    /**
     * @var string|null
     *
     * @ORM\Column(name="cobrador", type="string", length=100, nullable=true, options={"default"="NULL"})
     */
    private $cobrador = '';


    /**
     * @var string|null
     *
     * @ORM\Column(name="observacion", type="string", length=1000, nullable=true, options={"default"="NULL"})
     */
    private $observacion = '';

    /**
     * @var string|null
     *
     * @ORM\Column(name="auditoria", type="string", length=10000, nullable=true, options={"default"="NULL"})
     */
    private $auditoria = '';




    /**
     * @var \Tpago
     *
     * @ORM\ManyToOne(targetEntity="Tpago")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="idpago", referencedColumnName="idpago")
     * })
     */
    private $idpago;

    /**
     * @var \Tinternacional
     *
     * @ORM\ManyToOne(targetEntity="Tinternacional")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="idinternacional", referencedColumnName="idinternacional")
     * })
     */
    private $idinternacional;

    /**
     * @var \Tusuario
     *
     * @ORM\ManyToOne(targetEntity="Tusuario")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="idusuario", referencedColumnName="idusuario")
     * })
     */
    private $idusuario;

    public function getIdfactinternal(): ?int
    {
        return $this->idfactinternal;
    }

    public function getMonto(): ?string
    {
        return $this->monto;
    }

    public function setMonto(string $monto): self
    {
        $this->monto = $monto;

        return $this;
    }

    public function getFpagofact(): ?\DateTimeInterface
    {
        return $this->fpagofact;
    }

    public function setFpagofact(?\DateTimeInterface $fpagofact): self
    {
        $this->fpagofact = $fpagofact;

        return $this;
    }

    public function getCobrador(): ?string
    {
        return $this->cobrador;
    }

    public function setCobrador(?string $cobrador): self
    {
        $this->cobrador = $cobrador;

        return $this;
    }

    public function getObservacion(): ?string
    {
        return $this->observacion;
    }

    public function setObservacion(?string $observacion): self
    {
        $this->observacion = $observacion;

        return $this;
    }

    public function getAuditoria(): ?string
    {
        return $this->auditoria;
    }

    public function setAuditoria(?string $auditoria): self
    {
        $this->auditoria = $auditoria;

        return $this;
    }

    public function getIdpago(): ?Tpago
    {
        return $this->idpago;
    }

    public function setIdpago(?Tpago $idpago): self
    {
        $this->idpago = $idpago;

        return $this;
    }

    public function getIdinternacional(): ?Tinternacional
    {
        return $this->idinternacional;
    }

    public function setIdinternacional(?Tinternacional $idinternacional): self
    {
        $this->idinternacional = $idinternacional;

        return $this;
    }

    public function getIdusuario(): ?Tusuario
    {
        return $this->idusuario;
    }

    public function setIdusuario(?Tusuario $idusuario): self
    {
        $this->idusuario = $idusuario;

        return $this;
    }


}
