<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use function Symfony\Component\Translation\t;

/**
 * Tnacional
 *
 * @ORM\Table(name="tnacional", indexes={@ORM\Index(name="iddestino", columns={"iddestino"}), @ORM\Index(name="idorigen", columns={"idorigen"}), @ORM\Index(name="idempresa", columns={"idempresa"}), @ORM\Index(name="idestado", columns={"idestado"})})
 * @ORM\Entity
 */
class Tnacional
{
    /**
     * @var int
     *
     * @ORM\Column(name="idnacional", type="smallint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $idnacional;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="fechainicio", type="datetime", nullable=false)
     */
    private $fechainicio;



    /**
     * @var string|null
     *
     * @ORM\Column(name="observaciones", type="string", length=1000, nullable=true, options={"default"=""})
     */
    private $observaciones = '';



    /**
     * @var string|null
     *
     * @ORM\Column(name="auditoria", type="string", length=10000, nullable=true, options={"default"="NULL"})
     */
    private $auditoria = '';

    /**
     * @var \Tdestino
     *
     * @ORM\ManyToOne(targetEntity="Tdestino")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="iddestino", referencedColumnName="iddestino")
     * })
     */
    private $iddestino;

    /**
     * @var \Tempresa
     *
     * @ORM\ManyToOne(targetEntity="Tempresa")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="idempresa", referencedColumnName="idempresa")
     * })
     */
    private $idempresa;

    /**
     * @var \Testado
     *
     * @ORM\ManyToOne(targetEntity="Testado")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="idestado", referencedColumnName="idestado")
     * })
     */
    private $idestado;

    /**
     * @var \Torigen
     *
     * @ORM\ManyToOne(targetEntity="Torigen")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="idorigen", referencedColumnName="idorigen")
     * })
     */
    private $idorigen;

    public function getIdnacional(): ?int
    {
        return $this->idnacional;
    }

    public function getFechainicio(): ?\DateTimeInterface
    {
        return $this->fechainicio;
    }

    public function setFechainicio(\DateTimeInterface $fechainicio): self
    {
        $this->fechainicio = $fechainicio;

        return $this;
    }


    public function getObservaciones(): ?string
    {
        return $this->observaciones;
    }

    public function setObservaciones(?string $observaciones): self
    {
        $this->observaciones = $observaciones;

        return $this;
    }



    public function getAuditoria(): ?string
    {
        return $this->auditoria;
    }

    public function setAuditoria(?string $auditoria): self
    {
        $this->auditoria = $auditoria;

        return $this;
    }

    public function getIddestino(): ?Tdestino
    {
        return $this->iddestino;
    }

    public function setIddestino(?Tdestino $iddestino): self
    {
        $this->iddestino = $iddestino;

        return $this;
    }

    public function getIdempresa(): ?Tempresa
    {
        return $this->idempresa;
    }

    public function setIdempresa(?Tempresa $idempresa): self
    {
        $this->idempresa = $idempresa;

        return $this;
    }

    public function getIdestado(): ?Testado
    {
        return $this->idestado;
    }

    public function setIdestado(?Testado $idestado): self
    {
        $this->idestado = $idestado;

        return $this;
    }

    public function getIdorigen(): ?Torigen
    {
        return $this->idorigen;
    }

    public function setIdorigen(?Torigen $idorigen): self
    {
        $this->idorigen = $idorigen;

        return $this;
    }

    public function __toString()
    {
        return $this->getFechainicio() . $this->getIdempresa() . ' - Origen: ' . $this->getIdorigen() . ' - Destino: ' . $this->getIddestino();
    }

}
