<?php

namespace App\Form;

use App\Entity\Tempresa;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class TempresaType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('nombre',TextType::class,
                array('label'=>'Nombre de la Empresa',
                    'attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:10px', 'maxlength'=>100)))
            ->add('nit',TextType::class,
                array('label'=>'NIT',
                    'attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:10px', 'maxlength'=>12, 'onkeypress'=>'return controlnum(event)')))
            ->add('estado',CheckboxType::class,
                array('required'=>false, 'label'=>'Estado','attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:0px')))
        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => Tempresa::class,
        ]);
    }
}
