<?php

namespace App\Form;

use App\Entity\Tcamion;
use App\Entity\Tdestino;
use App\Entity\Tempresa;
use App\Entity\Tinternacional;
use App\Entity\Torigen;
use App\Entity\Tpago;
use App\Entity\Tservicio;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Validator\Constraints\File;

use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class TinternacionalType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder

            ->add('micdta',TextType::class,
                array('label'=>'No. de MIC/DTA',
                    'attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:10px', 'maxlength'=>8, 'onkeypress'=>'return controlnum(event)')))

            ->add('fechasalida',DateType::class, array(
                'widget'=>'single_text',
                'html5' => false,
                'input' => 'datetime',
                'label'=>'Fecha de Salida',
                'format'=>'dd/MM/yyyy',
                'attr'=> ['class'=>'form-control mydatepicker', 'style' => 'margin-bottom:5px','placeholder'=>'dd/mm/yyyy']))

            ->add('fechaentrega',DateType::class, array(
                'widget'=>'single_text',
                'html5' => false,
                'input' => 'datetime',
                'label'=>'Fecha de Entrega',
                'format'=>'dd/MM/yyyy',
                'attr'=> ['class'=>'form-control mydatepicker', 'style' => 'margin-bottom:5px','placeholder'=>'dd/mm/yyyy']))

            ->add('fcobrofact',DateType::class, array(
                'widget'=>'single_text',
                'html5' => false,
                'input' => 'datetime',
                'label'=>'Fecha de Factura',
                'format'=>'dd/MM/yyyy',
                'attr'=> ['class'=>'form-control mydatepicker', 'style' => 'margin-bottom:5px','placeholder'=>'dd/mm/yyyy']))

            ->add('fpagofact',DateType::class, array(
                'widget'=>'single_text',
                'html5' => false,
                'input' => 'datetime',
                'label'=>'Fecha de Pago de Factura',
                'format'=>'dd/MM/yyyy',
                'attr'=> ['class'=>'form-control mydatepicker', 'style' => 'margin-bottom:5px','placeholder'=>'dd/mm/yyyy']))

            ->add('mic',CheckboxType::class,
                array('required'=>false, 'label'=>'Manifiesto de Carga','attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:0px')))
            ->add('crt',CheckboxType::class,
                array('required'=>false, 'label'=>'Carta Porte','attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:0px')))
            ->add('pr',CheckboxType::class,
                array('required'=>false, 'label'=>'Parte de Recepción','attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:0px')))
            ->add('inv',CheckboxType::class,
                array('required'=>false, 'label'=>'Inventario','attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:0px')))
            ->add('cn',CheckboxType::class,
                array('required'=>false, 'label'=>'Contrato','attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:0px')))

            ->add('fac',TextType::class,
                array('label'=>'No. de Carnet',
                    'attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:10px', 'maxlength'=>8, 'onkeypress'=>'return controlnum(event)')))

            ->add('monto', NumberType::class,
                array('label'=>'Monto Bs.',
                    'attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:10px', 'maxlength'=>8, 'onkeypress'=>'return controlnum(event)')))

            ->add('flete', NumberType::class,
                array('label'=>'Monto Bs.',
                    'attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:10px', 'maxlength'=>8, 'onkeypress'=>'return controlnum(event)')))

            ->add('descuento', NumberType::class,
                array('label'=>'Descuento Bs.',
                    'attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:10px', 'maxlength'=>8, 'onkeypress'=>'return controlnum(event)')))

            ->add('observacion',TextType::class,
                array('label'=>'Observaciones',
                    'attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:10px', 'maxlength'=>1000)))

            ->add('observaciondesc',TextType::class,
                array('label'=>'Detalle de Descuento o Pago',
                    'attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:10px', 'maxlength'=>1000)))

            ->add('archivo', FileType::class, [
                'label' => 'Documento de Respaldo (PDF)',

                // unmapped means that this field is not associated to any entity property
                'mapped' => false,

                // make it optional so you don't have to re-upload the PDF file
                // every time you edit the Product details
                'required' => false,

                'attr'=>array('class'=>'form-control dropify', 'style' => 'margin-bottom:10px'),

                // unmapped fields can't define their validation using annotations
                // in the associated entity, so you can use the PHP constraint classes
                'constraints' => [
                    new File([
                        'maxSize' => '4024k',
                        'mimeTypes' => [
                            'application/pdf',
                            'application/x-pdf',
                        ],
                        'mimeTypesMessage' => 'Por favor suba un archivo PDF válido',
                    ])
                ],
            ])

//            ->add('auditoria')

            ->add('idcamion', EntityType::class, [
                'label' => 'Elige un camión',
                'attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:10px'),
                'class' => Tcamion::class,
                'placeholder' => '---- Escoge un camión',
            ])

            ->add('idorigen', EntityType::class, [
                'label' => 'Lugar de Origen',
                'attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:10px'),
                'class' => Torigen::class,
                'placeholder' => '---- Escoge un origen',
                'query_builder' => function ($er) {
                    return $er->createQueryBuilder('p')
                        ->select('p') // Entity Persona
//						->from(Persona::class, 'p')
                        ->where('p.abreviacion=:tipoPersona ')
                        ->setParameter('tipoPersona', 'Internacional')
                        ->orderBy('p.descripcion', 'ASC');
                },
            ])

            ->add('iddestino', EntityType::class, [
                'label' => 'Lugar de Destino',
                'attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:10px'),
                'class' => Tdestino::class,
                'placeholder' => '---- Escoge un destino',
                'query_builder' => function ($er) {
                    return $er->createQueryBuilder('p')
                        ->select('p') // Entity Persona
//						->from(Persona::class, 'p')
                        ->where('p.abreviacion=:tipoPersona ')
                        ->setParameter('tipoPersona', 'Nacional')
                        ->orderBy('p.descripcion', 'ASC');
                },
            ])

//            ->add('idestado')

            ->add('idpago', EntityType::class, [
                'label' => 'Forma de Pago',
                'attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:10px'),
                'class' => Tpago::class,
                'placeholder' => '---- Escoge la forma de Pago',
            ])

            ->add('idservicio', EntityType::class, [
                'label' => 'Clasificación de Servicio',
                'attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:10px'),
                'class' => Tservicio::class,
                'placeholder' => '---- Escoge una clasificación de servicio',
            ])

//            ->add('idusuario')

            ->add('idempresa', EntityType::class, [
                'label' => 'Empresa',
                'attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:10px'),
                'class' => Tempresa::class,
                'placeholder' => '---- Escoge una empresa',
            ])

            ->add('idempresa2', EntityType::class, [
                'label' => 'Empresa',
                'attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:10px'),
                'class' => Tempresa::class,
                'placeholder' => '---- Escoge una empresa de apoyo',
            ])


        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => Tinternacional::class,
        ]);
    }
}
