<?php

namespace App\Form;

use App\Entity\Tregnal;
use App\Entity\Tusuario;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class Tregnal_adjuntaType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $misFacturas = $options['misFacturas'];
        $choices = array();
        foreach($misFacturas as $miFactura)
        {
            $key = $miFactura->getFactura();
            $choices[$key] = $miFactura->getFactura();
        }

        $filters = array(3, 4);
        $builder
//            ->add('fechasalida',DateType::class, array(
//                'widget'=>'single_text',
//                'html5' => false,
//                'input' => 'datetime',
//                'label'=>'Fecha de Salida',
//                'format'=>'dd/MM/yyyy',
//                'attr'=> ['class'=>'form-control mydatepicker', 'style' => 'margin-bottom:5px','placeholder'=>'dd/mm/yyyy']))

            ->add('chasis',TextType::class,
                array('label'=>'Chasis',
                    'attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:10px', 'maxlength'=>20)))

            ->add('marca',TextType::class,
                array('label'=>'Marca',
                    'attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:10px', 'maxlength'=>50)))

            ->add('modelo',TextType::class,
                array('label'=>'Modelo/Tipo',
                    'attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:10px', 'maxlength'=>100)))

//            ->add('fechapago')

            ->add('observaciones',TextType::class,
                array('label'=>'Observaciones',
                    'attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:10px', 'maxlength'=>1000)))

//            ->add('auditoria')

//            ->add('movimiento', ChoiceType::class, array(
//                'label'=>'Movimiento: ',
//                'attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:10px', 'maxlength'=>20 ),
//                'placeholder' => '----Escoge movimiento',
//                'choices'   => array(
//                    'Despachado' => 'Despachado',
//                    'Entregado'   => 'Entregado',
//                ),
//                'multiple'  => false,
//            ))

//            ->add('fechaentrega',DateType::class, array(
//                'widget'=>'single_text',
//                'html5' => false,
//                'input' => 'datetime',
//                'label'=>'Fecha de Entrega',
//                'format'=>'dd/MM/yyyy',
//                'attr'=> ['class'=>'form-control mydatepicker', 'style' => 'margin-bottom:5px','placeholder'=>'dd/mm/yyyy']))

//            ->add('idnacional')

            ->add('idusuario', EntityType::class, [
                'label' => 'Transportista',
                'class' => Tusuario::class,
                'choice_label' => 'nombres',
                'placeholder' => '--- Escoja un Transportista',
                'query_builder' => function ($er) use ($filters){
                    return $er->createQueryBuilder('p')
                        ->select('p') // Entity
//						->from(Persona::class, 'p')
                        ->where('p.idrol IN (:rol)')
                        ->setParameter('rol', $filters)
                        ->orderBy('p.nombres', 'ASC');
                },
                ])

//            ->add('idusuario2', EntityType::class, [
//                'label' => 'Recepciona:',
//                'class' => Tusuario::class,
//                'choice_label' => 'nombres',
//                'placeholder' => '--- Escoja un Recepcionista',
//                'query_builder' => function ($er) {
//                    return $er->createQueryBuilder('p')
//                        ->select('p') // Entity
////						->from(Persona::class, 'p')
//                        ->where('p.idrol=:rol')
//                        ->setParameter('rol', '5')
//                        ->orderBy('p.nombres', 'ASC');
//                },
//                ])

//            ->add('factura',TextType::class,
//                array('label'=>'Factura',
//                    'attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:10px', 'maxlength'=>8, 'onkeypress'=>'return controlnum(event)')))

	        ->add('factura',ChoiceType::class, array(
		        'label'=>'Cursos Habilitados',
		        'choices' => $choices,
		        'attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:10px'),
		        'placeholder' => '----Escoge una Factura',
	            'required'=> true))


            //            ->add('archivo',FileType::class, array(
//                'required'=>false,
//                'mapped' => false,
//                'attr'=>array('class'=>'form-control dropify', 'style' => 'margin-bottom:10px'),
//                'label'=>'Documento de Respaldo',
//                'data_class'=>null))



//            ->add('archivo', FileType::class, [
//                'label' => 'Documento de Respaldo (PDF)',
//
//                // unmapped means that this field is not associated to any entity property
//                'mapped' => false,
//
//                // make it optional so you don't have to re-upload the PDF file
//                // every time you edit the Product details
//                'required' => false,
//
//                'attr'=>array('class'=>'form-control dropify', 'style' => 'margin-bottom:10px'),
//
//                // unmapped fields can't define their validation using annotations
//                // in the associated entity, so you can use the PHP constraint classes
//                'constraints' => [
//                    new File([
//                        'maxSize' => '1024k',
//                        'mimeTypes' => [
//                            'application/pdf',
//                            'application/x-pdf',
//                        ],
//                        'mimeTypesMessage' => 'Por favor suba un archivo PDF válido',
//                    ])
//                ],
//            ])

        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => Tregnal::class,
            'misFacturas'=> null,
        ]);
    }
}
