<?php

namespace App\Controller;

use App\Entity\Tcamion;
use App\Form\TcamionType;
use App\Models\DocumentAny;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

/**
 * @Route("/tcamion")
 */
class TcamionController extends AbstractController
{
    /**
     * @Route("/", name="tcamion_index", methods={"GET"})
     */
    public function index(): Response
    {
        $tcamions = $this->getDoctrine()
            ->getRepository(Tcamion::class)
            ->findAll();

        $deleteFormAjax = $this->createCustomForm(':USER_ID', 'DELETE', 'tcamion_delete');
        
        return $this->render('tcamion/index.html.twig', [
            'tcamions' => $tcamions,
            'delete_form_ajax' => $deleteFormAjax->createView()
        ]);
    }

    /**
     * @Route("/new", name="tcamion_new", methods={"GET","POST"})
     */
    public function new(Request $request): Response
    {
        $tcamion = new Tcamion();
        $form = $this->createForm(TcamionType::class, $tcamion);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $image = $form['foto']->getData();

            if(!$image) {
                $tcamion->setFoto('camion_generico.jpg' );
                $entityManager = $this->getDoctrine()->getManager();
                $entityManager->persist($tcamion);
                $entityManager->flush();

                $this->addFlash('mensaje', 'Se creó el registro del camión exitósamente');
                return $this->redirectToRoute('tcamion_index');
            }

            if(($image instanceof UploadedFile) && ($image->getError() == '0'))
            {
                $originalName = $image->getClientOriginalName();
                $name_array = explode('.',$originalName);
                $file_type = $name_array[sizeof($name_array) - 1];
                $valid_filetypes = array('jpg','jpeg','png','bmp');
                if(in_array(strtolower($file_type), $valid_filetypes))
                {
                    $document = new DocumentAny();
                    $document->setFile($image);

                    $document->setSubDirectory('camiones');
                    $document->processFile();
                    $nombre=$document->getFilePersistencePath();

                    $tcamion->setFoto($nombre);

                    $entityManager = $this->getDoctrine()->getManager();
                    $entityManager->persist($tcamion);
                    $entityManager->flush();

                    $this->addFlash('mensaje', 'Se creó el registro del camión exitósamente');
                    return $this->redirectToRoute('tcamion_index');
                }
                else
                {
                    $this->get('session')->getFlashBag()->add('mensaje',
                        'La extension del archivo no es la correcta');
//                    return $this->redirect($this->generateUrl('tusuario_index'));
                    return $this->redirectToRoute('tcamion_index');
                }
            }
            else
            {
                $this->get('session')->getFlashBag()->add('mensaje',
                    'No ingreso el archivo o se produjo un error inesperado');
//                return $this->redirect($this->generateUrl('tusuario_index'));
                return $this->redirectToRoute('tcamion_index');
            }

        }

        return $this->render('tcamion/new.html.twig', [
            'tcamion' => $tcamion,
            'form' => $form->createView(),
        ]);
    }

    /**
     * @Route("/{idcamion}", name="tcamion_show", methods={"GET"})
     */
    public function show(Tcamion $tcamion): Response
    {
        return $this->render('tcamion/show.html.twig', [
            'tcamion' => $tcamion,
        ]);
    }

    /**
     * @Route("/{idcamion}/edit", name="tcamion_edit", methods={"GET","POST"})
     */
    public function edit(Request $request, Tcamion $tcamion): Response
    {
        $imageEmpty = $tcamion->getFoto();

        $form = $this->createForm(TcamionType::class, $tcamion);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $image = $form['foto']->getData();

            if (!$image)
            {
                $tcamion->setFoto($imageEmpty);
                $this->getDoctrine()->getManager()->flush();

                $this->addFlash('mensaje', 'Se actualizó el registro del camión exitósamente');
                return $this->redirectToRoute('tcamion_index');
            }else
            {
                if(($image instanceof UploadedFile) && ($image->getError() == '0'))
                {
                    $originalName = $image->getClientOriginalName();
                    $name_array = explode('.',$originalName);
                    $file_type = $name_array[sizeof($name_array) - 1];
                    $valid_filetypes = array('jpg','jpeg','bmp');
                    if(in_array(strtolower($file_type), $valid_filetypes))
                    {
                        $document = new DocumentAny();
                        $document->setFile($image);
                        // la siguiente fila es opcional si quisiera guardar en una carpeta adicional... solo es para ordenar
                        $document->setSubDirectory('camiones');
                        $document->processFile();

                        $nombre=$document->getFilePersistencePath();
                        $tcamion->setFoto($nombre);

                        $this->getDoctrine()->getManager()->flush();

                        $this->addFlash('mensaje', 'Se actualizó el registro del camión exitósamente');
                        return $this->redirectToRoute('tcamion_index');

                    }else
                    {
                        $this->get('session')->getFlashBag()->add('mensaje',
                            'La extension del archivo no es la correcta');
                        return $this->redirectToRoute('tcamion_index');
                    }
                }else
                {
                    $this->get('session')->getFlashBag()->add('mensaje',
                        'No ingreso el archivo o se produjo un error inesperado');
                    return $this->redirectToRoute('tcamion_index');
                }
            }
        }

        return $this->render('tcamion/edit.html.twig', [
            'tcamion' => $tcamion,
            'form' => $form->createView(),
        ]);
    }

//    /**
//     * @Route("/{idcamion}", name="tcamion_delete", methods={"DELETE"})
//     */
//    public function delete(Request $request, Tcamion $tcamion): Response
//    {
//        if ($this->isCsrfTokenValid('delete'.$tcamion->getIdcamion(), $request->request->get('_token'))) {
//            $entityManager = $this->getDoctrine()->getManager();
//            $entityManager->remove($tcamion);
//            $entityManager->flush();
//        }
//
//        return $this->redirectToRoute('tcamion_index');
//    }

    private function createCustomForm($id, $method, $route)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl($route, array('id'=>$id)))
            ->setMethod($method)
            ->getForm();
    }


    private function deleteRegistro($em, $tCamion)
    {
        $em->remove($tCamion);
        $em->flush();

        $message = 'El camión ha sido eliminado exitósamente';
        //$this->get('session')->getFlashBag()->add('message', 'Se eliminó el registro exitosamente');
        $removed = 1;
        $alert = 'mensaje';

        return array('removed'=>$removed, 'message'=>$message, 'alert'=>$alert);
    }


    /**
     * @Route("/delete/{id}", name="tcamion_delete")
     */
    public function deleteAction(Request $request, Tcamion $tCamion)
    {
        $form = $this->createCustomForm($tCamion->getIdcamion(), 'DELETE', 'tcamion_delete');
        $form->handleRequest($request);
        $em = $this->getDoctrine()->getManager();

        if ($form->isSubmitted() && $form->isValid()) {

            if($request->isXMLHttpRequest())
            {
                $res = $this->deleteRegistro($em, $tCamion);

                return new Response(
                    json_encode(array('removed'=>$res['removed'], 'message'=>$res['message'], )),
                    200,
                    array('Content-Type'=>'application/json')
                );
            }

            $res = $this->deleteRegistro($em, $tCamion);

            $this->addFlash($res['alert'], $res['message']);

            return $this->redirectToRoute('tdestino_index');
        }
    }

}
