<?php

namespace App\Form;

use App\Entity\Tfactnal;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

use Symfony\Component\Form\Extension\Core\Type\DateType;

class TfactnalType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder

            ->add('fcobrofact',DateType::class, array(
                'widget'=>'single_text',
                'html5' => false,
                'input' => 'datetime',
                'label'=>'Fecha de Factura',
                'format'=>'dd/MM/yyyy',
                'attr'=> ['class'=>'form-control mydatepicker', 'style' => 'margin-bottom:5px','placeholder'=>'dd/mm/yyyy']))

            ->add('factura',TextType::class,
                array('label'=>'No. de Factura',
                    'attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:10px', 'maxlength'=>8, 'onkeypress'=>'return controlnum(event)')))

//            ->add('fpagofact')


            ->add('monto', NumberType::class,
                array('label'=>'Monto Bs.',
                    'attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:10px', 'maxlength'=>8, 'onkeypress'=>'return controlnum(event)')))

            ->add('observacion',TextType::class,
                array('label'=>'Observaciones',
                    'attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:10px', 'maxlength'=>1000)))

//            ->add('auditoria')
//            ->add('idpago')
//            ->add('idnacional')
//            ->add('idusuario')

        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => Tfactnal::class,
        ]);
    }
}
