<?php

namespace App\Repository;

use App\Entity\Tusuario;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @method Tusuario|null find($id, $lockMode = null, $lockVersion = null)
 * @method Tusuario|null findOneBy(array $criteria, array $orderBy = null)
 * @method Tusuario[]    findAll()
 * @method Tusuario[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class TusuarioRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Tusuario::class);
    }

    // /**
    //  * @return Tusuario[] Returns an array of Tusuario objects
    //  */
    /*
    public function findByExampleField($value)
    {
        return $this->createQueryBuilder('t')
            ->andWhere('t.exampleField = :val')
            ->setParameter('val', $value)
            ->orderBy('t.id', 'ASC')
            ->setMaxResults(10)
            ->getQuery()
            ->getResult()
        ;
    }
    */

    /*
    public function findOneBySomeField($value): ?Tusuario
    {
        return $this->createQueryBuilder('t')
            ->andWhere('t.exampleField = :val')
            ->setParameter('val', $value)
            ->getQuery()
            ->getOneOrNullResult()
        ;
    }
    */

    public function getRegNal()
    {
        return $this->getEntityManager()
            ->createQuery(
                "SELECT a.idnacional, a.fechainicio, b.nombre, c.descripcion as origen, d.descripcion as destino, e.descripcion as estado, a.observaciones, count(f.idregnal) as registros, CURRENT_TIMESTAMP() as Hoy  
								FROM App:Tnacional a
								JOIN App:Tempresa b WITH a.idempresa = b.idempresa
								JOIN App:Torigen c WITH a.idorigen = c.idorigen
								JOIN App:Tdestino d WITH a.iddestino = d.iddestino
								JOIN App:Testado e WITH a.idestado = e.idestado   
								LEFT JOIN App:Tregnal f WITH a.idnacional = f.idnacional
								GROUP BY a.idnacional, a.fechainicio, b.nombre, c.descripcion, d.descripcion, e.descripcion , a.observaciones
								"
            )->getResult();
    }

    public function getRegNacional($idNacional)
    {
        return $this->getEntityManager()
            ->createQuery(
                "SELECT a.idregnal, (a.idnacional) as idnacional, a.fechaentrega, a.chasis, a.marca, a.modelo, c.nombres, a.fechapago, a.observaciones, a.fecharegistro, 
                        a.fechasalida, b.descripcion, a.factura, a.archivo, CURRENT_TIMESTAMP() as Hoy, a.descuento, a.montopagado  
								FROM App:Tregnal a 
								JOIN App:Tmovimiento b WITH a.idmovimiento = b.idmovimiento
								LEFT JOIN App:Tusuario c WITH a.idusuario = c.idusuario
								WHERE a.idnacional = " . $idNacional
            )->getResult();
    }

    public function borraFacturaNal($idFactNal)
    {
        return $this->getEntityManager()
            ->createQuery(
                "DELETE App:Tfactnal a WHERE a.idfactnal =" .$idFactNal
            )->getResult();
    }

    public function getFactCobrarNal()
    {
        return $this->getEntityManager()
            ->createQuery(
                "SELECT a.idnacional, a.fechainicio, b.nombre, c.descripcion as origen, d.descripcion as destino, e.descripcion as estado, a.observaciones,  
                        CURRENT_TIMESTAMP() as Hoy, g.fcobrofact, g.factura, sum(g.monto) as suma, h.nombres, g.observacion  
								FROM App:Tnacional a
								JOIN App:Tfactnal g WITH a.idnacional = g.idnacional
								JOIN App:Tempresa b WITH a.idempresa = b.idempresa
								JOIN App:Torigen c WITH a.idorigen = c.idorigen
								JOIN App:Tdestino d WITH a.iddestino = d.iddestino
								JOIN App:Testado e WITH a.idestado = e.idestado
								JOIN App:Tusuario h WITH g.idusuario = h.idusuario
								WHERE g.fpagofact IS NULL   								
								GROUP BY a.idnacional, a.fechainicio, b.nombre, c.descripcion, d.descripcion, e.descripcion , a.observaciones, 
								g.fcobrofact, g.factura, h.nombres, g.observacion								
								"
            )->getResult();
    }

    public function getFactPagadoNal()
    {
        return $this->getEntityManager()
            ->createQuery(
                "SELECT a.idnacional, a.fechainicio, b.nombre, c.descripcion as origen, d.descripcion as destino, e.descripcion as estado, a.observaciones,  
                        CURRENT_TIMESTAMP() as Hoy, g.fcobrofact, g.factura, sum(g.monto) as suma, h.nombres, g.observacion, i.descripcion as formapago   
								FROM App:Tnacional a
								JOIN App:Tfactnal g WITH a.idnacional = g.idnacional
								JOIN App:Tempresa b WITH a.idempresa = b.idempresa
								JOIN App:Torigen c WITH a.idorigen = c.idorigen
								JOIN App:Tdestino d WITH a.iddestino = d.iddestino
								JOIN App:Testado e WITH a.idestado = e.idestado
								JOIN App:Tusuario h WITH g.idusuario = h.idusuario
								JOIN App:Tpago i WITH g.idpago = i.idpago
								WHERE g.fpagofact IS NOT NULL   								
								GROUP BY a.idnacional, a.fechainicio, b.nombre, c.descripcion, d.descripcion, e.descripcion , a.observaciones, 
								g.fcobrofact, g.factura, h.nombres, g.observacion, i.descripcion								
								"
            )->getResult();
    }

    public function getTransxPagarNal()
    {
        return $this->getEntityManager()
            ->createQuery(
                "SELECT a.idnacional, a.fechainicio, b.nombre, c.descripcion as origen, d.descripcion as destino, e.descripcion as estado, a.observaciones,  
                        CURRENT_TIMESTAMP() as Hoy, g.fechaentrega as fechaentrega, g.factura, g.montopagar as suma, h.nombres, g.chasis  
								FROM App:Tnacional a
								JOIN App:Tregnal g WITH a.idnacional = g.idnacional
								JOIN App:Tempresa b WITH a.idempresa = b.idempresa
								JOIN App:Torigen c WITH a.idorigen = c.idorigen
								JOIN App:Tdestino d WITH a.iddestino = d.iddestino
								JOIN App:Testado e WITH a.idestado = e.idestado
								JOIN App:Tusuario h WITH g.idusuario = h.idusuario
								WHERE g.idmovimiento = 3
								"
            )->getResult();
    }

    public function getTransportistasPagadosNal()
    {
        return $this->getEntityManager()
            ->createQuery(
                "SELECT a.idnacional, a.fechainicio, b.nombre, c.descripcion as origen, d.descripcion as destino, e.descripcion as estado, a.observaciones, CURRENT_TIMESTAMP() as Hoy, 
                        g.fechaentrega, g.factura, (g.montopagar - g.descuento) as suma, h.nombres, g.observaciondesc, i.descripcion as formapago, g.chasis,
                        g.fechapago, g.descuento   
								FROM App:Tnacional a
								JOIN App:Tregnal g WITH a.idnacional = g.idnacional
								JOIN App:Tempresa b WITH a.idempresa = b.idempresa
								JOIN App:Torigen c WITH a.idorigen = c.idorigen
								JOIN App:Tdestino d WITH a.iddestino = d.iddestino
								JOIN App:Testado e WITH a.idestado = e.idestado
								JOIN App:Tusuario h WITH g.idusuario = h.idusuario
								JOIN App:Tpago i WITH g.idpago = i.idpago
								WHERE g.idmovimiento = 4
								"
            )->getResult();
    }
}
